(function( $ ) {
    'use strict';
    var VisualTrunkAnimation = {
        initTrunk: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualTrunkAnimation.initTrunkWidget);
        },
        initTrunkWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var trunkAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        trunkAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                trunkAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = trunkAnimationArgs.marvy_enable_trunk_animation;
                    settings.color = trunkAnimationArgs.marvy_trunk_animation_color;
                    settings.bgColor = trunkAnimationArgs.marvy_trunk_animation_background_color;
                    settings.spacing = trunkAnimationArgs.marvy_trunk_animation_spacing;
                    settings.chaos = trunkAnimationArgs.marvy_trunk_animation_chaos;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_trunk_animation");
                settings.color = $scope.data("marvy_trunk_animation_color");
                settings.bgColor = $scope.data("marvy_trunk_animation_background_color");
                settings.spacing = $scope.data("marvy_trunk_animation_spacing");
                settings.chaos = $scope.data("marvy_trunk_animation_chaos");
            }

            if (settings.switch) {
                trunkAnimation(target, settings, sectionId);
            }
        }
    };

    function trunkAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-trunk-section-" + sectionId);
        if (checkElement.length >= 0) {

            var trunk_div = document.createElement('div');
            trunk_div.classList.add("marvy-trunk-section-" + sectionId);

            document.querySelector(target).appendChild(trunk_div);
            document.querySelector(target).classList.add("marvy-custom-trunk-animation-section-" + sectionId);

            // Set Z-index for section container
            var trunkZindex = document.querySelector('.marvy-custom-trunk-animation-section-'+sectionId+' .elementor-container');
            trunkZindex.style.zIndex = '99';

            // Set min height
            var trunkMinHeight = document.querySelector(".elementor-element-"+sectionId);
            trunkMinHeight.closest('.elementor-top-section').style.minHeight = "200px";

            var trunkAnimation = VANTA.TRUNK({
                el: ".marvy-trunk-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 200.00,
                scale: 1.00,
                scaleMobile: 1.00,
                color: settings.color,
                backgroundColor: settings.bgColor,
                spacing: settings.spacing,
                chaos: settings.chaos
            });
            render(trunkAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualTrunkAnimation.initTrunk);
})( jQuery );